 ; Ŀ
 ;   Avalanch - read a text file into variables and sysvars.               
 ;   Copyright 1997 by Rocket Software                                     
 ;   There are four types - snow, rock, paperwork, and macaroni & cheese.  
 ; 

 ; Ŀ
 ;   Funl2 - Takes two arguments, a list and an atom.                      
 ;   If the atom is a member of the list then the list is returned with    
 ;   the atom moved to the front.                                          
 ;   Otherwise the list is returned unchanged.                             
 ; 
 (DEFUN FUNL2 (list0 elm / gnulis num nxt)
  (setq num 0)
  (setq len (length list0))
  (while (and (< num len)
              (/= (setq nxt (nth num list0)) elm))
         (setq gnulis (append gnulis (list nxt)))
         (setq num (1+ num)))
  (setq gnulis (append gnulis (cdr (member elm list0))))
  (if (< (length gnulis) len) (setq gnulis (cons elm gnulis)))
 gnulis)
 ; Ŀ
 ;   Funl2 end.                                                            
 ; 

 ; Ŀ
 ;   Funl - Takes two arguments, a list and an atom.                       
 ;   If the atom is a member of the list then the list is returned with    
 ;   the atom moved to the front.                                          
 ;   Otherwise nil is returned.                                            
 ; 
 (DEFUN FUNL (list0 elm / llast gnulis num nxt)
  (if (setq llast (member elm list0))
      (progn
           (setq llast (cdr llast))
           (setq gnulis (list elm))
           (setq num 0)
           (while (/= (setq nxt (nth num list0)) elm)
                  (setq gnulis (append gnulis (list nxt)))
                  (setq num (1+ num)))
           (setq gnulis (append gnulis llast))))
 gnulis)
 ; Ŀ
 ;   Funl end.                                                             
 ; 

 ; Ŀ
 ;   Opn - open a drawing name contained in one of the variables Last1-5.  
 ;   Takes one argument, a number - 1 = open the name in Last1, etc.       
 ;   Called from the menu.                                                 
 ; 
 (DEFUN OPN (ndx / filnam eoq)
  (setvar "cmdecho" 0)
  (if (and (setq filnam (eval (read (strcat "last" ndx))))
           (/= filnam ""))
      (progn
           (command ".open")
           (if (/= (getvar "dbmod") 0)
               (progn
                    (initget "Yes No")
                    (setq eoq (getkword "Save changes? <Y>: "))               
                    (if (/= eoq "No")
                        (command "n")
                        (command "y"))))
           (command filnam)))
 (princ))
 ; Ŀ
 ;   Opn end.                                                              
 ; 

 ; Ŀ
 ;   Nopath1 - returns a filename without the path.                        
 ; 
 (DEFUN NOPATH1 (tt / pos)
  (setq pos (strlen tt))                            ; start at end of string
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \ or
                  (= (substr tt pos 1) ":"))        ;    char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ; and set pos to first
         (setq pos (1- pos)))                       ; decrement pos
 tt)
 ; Ŀ
 ;   Nopath1 end.                                                          
 ; 

 ; Ŀ
 ;   Avalanch - read the drawing names text file into the sysvars          
 ;   Users1-5 as filenames without a path, and into variables Last1-5 as   
 ;   path and filename.                                                    
 ; 
 (DEFUN C:AVALANCH (/ fn num filstr namlst cnam)
 ; Ŀ
 ;   If the datafile can be opened then read the lines into the variables  
 ;   and the names minus paths into the corresponding user string          
 ;   sysvars.                                                              
 ;   Ignore empty lines or those beginning with "User".                    
 ; 
  (if (setq fn (open "lastfile" "r"))
      (progn
           (setq num 0)
           (while (and (< num 5) (setq filstr (read-line fn)))
                  (if (and (/= filstr "")
                           (/= (substr filstr 1 4) "User"))
                      (progn
                           (set (read (strcat "last" 
                                          (itoa (setq num (1+ num))))) filstr)
                           (setq namlst (append namlst (list filstr)))
                           (setvar (strcat "users" (itoa num))
                                                          (nopath1 filstr)))))
           (close fn))
 ; Ŀ
 ;   If the file can't be opened, empty the sysvars.  The Variables won't  
 ;   exist since the drawing should just have been opened.                 
 ; 
      (progn
           (setq num 0)
           (while (< num 5)
                  (setvar (strcat "users" (itoa (setq num (1+ num)))) "."))))
 ; Ŀ
 ;   Get the current drawing name.                                         
 ; 
  (setq cnam (strcat (getvar "dwgprefix") (setq namm (getvar "dwgname"))))
 ; Ŀ
 ;   Reorder Namlst: If the current drawing name is a member thereof,      
 ;   move it to the front; otherwise shorten the list to four elements     
 ;   and add cnam as the new first one.                                    
 ; 
  (if (setq namls2 (funl namlst cnam))
      (setq namlst namls2)
      (progn
           (while (> (length namlst) 4)
                  (setq namlst (reverse (cdr (reverse namlst)))))
           (setq namlst (cons cnam namlst))))
 ; Ŀ
 ;   Now open the data file again and replace the contents with the names  
 ;   from the list Namlst.                                                 
 ;   If the list contains less than five elements then empty any           
 ;   leftover sysvars.                                                     
 ; 
  (if (and (/= 4 (logand 4 (getvar "cmdactive"))) ; inactivate during a script
           (/= namm "UNNAMED")
           (/= namm "Drawing.dwg")
           (setq fn (open "lastfile" "w")))
      (progn
           (setq namlst (funl2 namlst cnam))
           (setq num 0)
           (while (setq nxfil (nth num namlst))
                  (setq num (1+ num))
                  (write-line nxfil fn))
           (if (setq user (getvar "loginname"))
               (write-line (strcat "\nUser: " user) fn)
               (write-line "\nUser: unknown" fn))
           (close fn)
           (while (< num 5)
                  (setvar (strcat "users" (itoa (setq num (1+ num)))) "."))))
 (princ))